; App.s : AvP[V
;


; W[錾
;
    .module App

; Qƃt@C
;
    .include    "bios.inc"
    .include    "vdp.inc"
    .include    "System.inc"
    .include	"App.inc"
    .include    "Title.inc"
    .include    "Game.inc"

; Oϐ錾
;
    .globl  _patternTable


; CODE ̈
;
    .area   _CODE

; AvP[V
;
_AppInitialize::
    
    ; WX^̕ۑ
    
    ; AvP[V̏
    
    ; ʕ\̒~
    call    DISSCR
    
    ; rfI̐ݒ
    ld      hl, #videoScreen1
    ld      de, #_videoRegister
    ld      bc, #0x08
    ldir
    ld      hl, #_request
    set     #REQUEST_VIDEO_REGISTER, (hl)
    
    ; 荞݂̋֎~
    di
    
    ; VDP |[g̎擾
    ld      a, (_videoPort + 1)
    ld      c, a
    
    ; XvCgWFl[^̓]
    inc     c
    ld      a, #<APP_SPRITE_GENERATOR_TABLE
    out     (c), a
    ld      a, #(>APP_SPRITE_GENERATOR_TABLE | 0b01000000)
    out     (c), a
    dec     c
    ld      hl, #(_patternTable + 0x0000)
    ld      d, #0x08
0$:
    ld      e, #0x10
1$:
    push    de
    ld      b, #0x08
    otir
    ld      de, #0x78
    add     hl, de
    ld      b, #0x08
    otir
    ld      de, #0x80
    or      a
    sbc     hl, de
    pop     de
    dec     e
    jr      nz, 1$
    ld      a, #0x80
    add     a, l
    ld      l, a
    ld      a, h
    adc     a, #0x00
    ld      h, a
    dec     d
    jr      nz, 0$
    
    ; p^[WFl[^̓]
    ld      hl, #(_patternTable + 0x0800)
    ld      de, #APP_PATTERN_GENERATOR_TABLE_0
    ld      bc, #0x0800
    call    LDIRVM
    ld      hl, #(_patternTable + 0x0800)
    ld      de, #APP_PATTERN_GENERATOR_TABLE_1
    ld      bc, #0x0800
    call    LDIRVM
    ld      hl, #(_patternTable + 0x0800)
    ld      de, #APP_PATTERN_GENERATOR_TABLE_2
    ld      bc, #0x0800
    call    LDIRVM
    
    ; J[e[u̓]
    ld      hl, #(APP_COLOR_TABLE_0 + 0x0000)
    ld      a, #0xf1
    ld      bc, #0x1800
    call    FILVRM
    ld      hl, #(APP_COLOR_TABLE_0 + 0x0200)
    ld      a, #0x41
    ld      bc, #0x0080
    call    FILVRM
    ld      hl, #(APP_COLOR_TABLE_0 + 0x0280)
    ld      a, #0x51
    ld      bc, #0x0080
    call    FILVRM
    ld      hl, #(APP_COLOR_TABLE_1 + 0x0200)
    ld      a, #0x41
    ld      bc, #0x0080
    call    FILVRM
    ld      hl, #(APP_COLOR_TABLE_1 + 0x0280)
    ld      a, #0x51
    ld      bc, #0x0080
    call    FILVRM
    ld      hl, #(APP_COLOR_TABLE_2 + 0x0200)
    ld      a, #0x41
    ld      bc, #0x0080
    call    FILVRM
    ld      hl, #(APP_COLOR_TABLE_2 + 0x0280)
    ld      a, #0x51
    ld      bc, #0x0080
    call    FILVRM
    
    ; p^[l[̏
    ld      hl, #APP_PATTERN_NAME_TABLE_0
    xor     a
    ld      bc, #0x0600
    call    FILVRM
    
    ; 荞݋֎~̉
    ei
    
    ; Ԃ̏
    ld      a, #APP_STATE_GAME_INITIALIZE
    ld      (_appState), a
    
    ; WX^̕A
    
    ; I
    ret

; AvP[VXV
;
_AppUpdate::
    
    ; WX^̕ۑ
    push    hl
    push    bc
    push    de
    push    ix
    push    iy
    
    ; Ԃ̎擾
    ld      a, (_appState)
    
    ; ^Cg̏
1$:
    cp      #APP_STATE_TITLE_INITIALIZE
    jr      nz, 2$
    call    _TitleInitialize
    jr      9$
    
    ; ^Cg̍XV
2$:
    cp      #APP_STATE_TITLE_UPDATE
    jr      nz, 3$
    call    _TitleUpdate
    jr      9$
    
    ; Q[̏
3$:
    cp      #APP_STATE_GAME_INITIALIZE
    jr      nz, 4$
    call    _GameInitialize
    jr      9$
    
    ; Q[̍XV
4$:
    cp      #APP_STATE_GAME_UPDATE
    jr      nz, 3$
    call    _GameUpdate
;   jr      9$
    
    ; XV̏I
9$:

    ; WX^̕A
    pop     iy
    pop     ix
    pop     de
    pop     bc
    pop     hl
    
    ; I
    ret

; p^[l[]
;
_AppTransferPatternName:

    ; WX^̕ۑ
    
    ; p^[l[̓]
    xor     a
    ld      hl, #(_appPatternName + 0x0000)
    ld      (_videoTransfer + VIDEO_TRANSFER_VRAM_0_SRC), hl
    ld      hl, #(APP_PATTERN_NAME_TABLE_0)
    ld      (_videoTransfer + VIDEO_TRANSFER_VRAM_0_DST), hl
    ld      (_videoTransfer + VIDEO_TRANSFER_VRAM_0_BYTES), a
    ld      hl, #(_appPatternName + 0x0100)
    ld      (_videoTransfer + VIDEO_TRANSFER_VRAM_1_SRC), hl
    ld      hl, #(APP_PATTERN_NAME_TABLE_1)
    ld      (_videoTransfer + VIDEO_TRANSFER_VRAM_1_DST), hl
    ld      (_videoTransfer + VIDEO_TRANSFER_VRAM_1_BYTES), a
    ld      hl, #(_appPatternName + 0x0200)
    ld      (_videoTransfer + VIDEO_TRANSFER_VRAM_2_SRC), hl
    ld      hl, #(APP_PATTERN_NAME_TABLE_2)
    ld      (_videoTransfer + VIDEO_TRANSFER_VRAM_2_DST), hl
    ld      (_videoTransfer + VIDEO_TRANSFER_VRAM_2_BYTES), a
    ld      hl, #(_request)
    set     #REQUEST_VRAM, (hl)
    
    ; WX^̕A
    
    ; I
    ret

; 萔̒`
;

; VDP WX^liXN[Qj
;
videoScreen1:

    .db     0b00000010
    .db     0b10100010
    .db     APP_PATTERN_NAME_TABLE_0 >> 10
    .db     (APP_COLOR_TABLE_0 >> 6) | 0b01111111
    .db     (APP_PATTERN_GENERATOR_TABLE_0 >> 11) | 0b00000011
    .db     APP_SPRITE_ATTRIBUTE_TABLE >> 7
    .db     APP_SPRITE_GENERATOR_TABLE >> 11
    .db     0b00000000


; DATA ̈
;
    .area   _DATA

; ϐ̒`
;

; 
;
_appState::

    .ds     1

; p^[l[
;
_appPatternName::

    .ds     0x0300

